/****** Object:  StoredProcedure [dbo].[P_PDV_VD_CREDIARIO_CANCELADO]    Script Date: 11/28/2013 09:36:38 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_CREDIARIO_CANCELADO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PDV_VD_CREDIARIO_CANCELADO]
GO
GO
--EXEC P_PDV_VD_CREDIARIO_CANCELADO 1,1
CREATE PROCEDURE P_PDV_VD_CREDIARIO_CANCELADO @CD_EMP INT, @CD_FILIAL INT, @DT_INI DATETIME, @DT_FIM DATETIME
AS
SET NOCOUNT ON
DECLARE @CD_VD INT
DECLARE @CD_RC_DEB INT
DECLARE @STS_DP INT
DECLARE @DT_VD DATETIME

DECLARE ProcVendasCanceladas CURSOR FAST_FORWARD FOR 
SELECT 
	PDV_VD.CD_VD, 
	RC_CREDIARIO_FECHA_RC_DEB.CD_RC_DEB,
	RC_DEB.STS_DP,
	PDV_VD.DT_VD
FROM 
	RC_CREDIARIO_FECHA_RC_DEB INNER JOIN RC_CREDIARIO_FECHA ON 
	RC_CREDIARIO_FECHA_RC_DEB.CD_EMP = RC_CREDIARIO_FECHA.CD_EMP  AND 
	RC_CREDIARIO_FECHA_RC_DEB.CD_CTR_FECHA = RC_CREDIARIO_FECHA.CD_CTR_FECHA  
	INNER JOIN RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA ON 
	RC_CREDIARIO_FECHA.CD_CTR_FECHA=RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA.CD_CTR_FECHA  
	INNER JOIN RC_CREDIARIO_PARC ON 
	RC_CREDIARIO_PARC.CD_CTR=RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA.CD_CTR  
	INNER JOIN RC_CREDIARIO_PARC_PDV_VD ON 
	RC_CREDIARIO_PARC.CD_CTR = RC_CREDIARIO_PARC_PDV_VD.CD_CTR  
	INNER JOIN PDV_VD ON 
	PDV_VD.CD_EMP = RC_CREDIARIO_PARC_PDV_VD.CD_EMP AND 
	PDV_VD.CD_FILIAL = RC_CREDIARIO_PARC_PDV_VD.CD_FILIAL AND 
	PDV_VD.CD_VD = RC_CREDIARIO_PARC_PDV_VD.CD_VD 
	INNER JOIN RC_DEB ON
	RC_CREDIARIO_FECHA_RC_DEB.CD_EMP = RC_DEB.CD_EMP AND
	RC_CREDIARIO_FECHA_RC_DEB.CD_FILIAL = RC_DEB.CD_FILIAL AND
	RC_CREDIARIO_FECHA_RC_DEB.CD_RC_DEB = RC_DEB.CD_RC_DEB
WHERE 
	RC_CREDIARIO_FECHA_RC_DEB.CD_EMP=@CD_EMP
	AND RC_CREDIARIO_FECHA_RC_DEB.CD_FILIAL=@CD_FILIAL
	AND PDV_VD.DT_VD BETWEEN @DT_INI AND @DT_FIM
	AND PDV_VD.ST_VD =1
	AND RC_DEB.STS_DP <> 3

OPEN ProcVendasCanceladas;
FETCH NEXT FROM ProcVendasCanceladas INTO @CD_VD,@CD_RC_DEB,@STS_DP,@DT_VD 
WHILE @@FETCH_STATUS = 0
    BEGIN
		PRINT CONVERT(VARCHAR(10),@CD_VD)
		IF NOT EXISTS(SELECT
						TOP 1 CD_EMP
					 FROM
						RC_CRED
					WHERE
						CD_EMP =@CD_EMP
						AND CD_FILIAL = @CD_FILIAL
						AND CD_RC_DEB=@CD_RC_DEB)
		BEGIN
			UPDATE
				RC_DEB
			SET
				STS_DP =3
			WHERE
				CD_EMP =@CD_EMP
				AND CD_FILIAL=@CD_FILIAL
				AND CD_RC_DEB=@CD_RC_DEB 
		END
		FETCH NEXT FROM ProcVendasCanceladas INTO @CD_VD,@CD_RC_DEB,@STS_DP,@DT_VD 
    END;
CLOSE ProcVendasCanceladas;
DEALLOCATE ProcVendasCanceladas;